@echo off
TITLE s/nai/liu/m; MKV to MP4 Converter v0.2
SETLOCAL

:: Setup path to programs
SET MKVEXTPATH="E:\Rip\mkvtoolnix-unicode-3.0.0\mkvextract.exe"
SET MEDIAINFOPATH="E:\Rip\MediaInfo_CLI_0.7.26\MediaInfo.exe"
SET EAC3TOPATH="E:\Rip\eac3to_3.17\eac3to.exe"
SET AACENCPATH="E:\Rip\NeroDigitalAudio-1.3.3.0\win32\neroAacEnc.exe"
SET MP4BOXPATH="E:\Rip\MP4Box-0.4.6-dev_20090226\mp4box.exe"

:: Setup bit-rate for AAC encoding
SET AACBR=128000

:: Setup temporary files
SET TEMPDIR=.
SET TEMPINFO=%TEMPDIR%\info.temp
SET DEMUXPREFIX=mkvdemuxed_

:: Internal variables
SET ATRACK=0
SET VTRACK=0
SET SKIPATRANS=0

IF "%1" == "" GOTO PHELP
IF "%1" == "/?" GOTO PHELP
SET MKVFILE="%1"
SET MP4FILE="%1.mp4"
IF NOT EXIST %MKVFILE% (
  echo ERROR: File %MKVFILE% doesn't exist
  echo.
  GOTO END
)
GOTO PARSEMKV

:PHELP
echo MKV to MP4 Converter (Batch)
echo ================================
echo Usage:
echo   mkv2mp4.bat ^<mkv-file^>
echo.
echo Output will be ^<mkv-file^>.mp4
echo.
GOTO END

:PARSEMKV
echo Parsing MKV files ...
IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )

%MEDIAINFOPATH% --inform=Video;%%ID%% %MKVFILE% > %TEMPINFO%
FOR /F "tokens=*" %%A IN ('type %TEMPINFO%') DO IF NOT "%%A" == "" (SET VTRACK=%%A)
IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
IF %VTRACK% == 0 (
  echo ERROR: Video track not found.
  GOTO END
) ELSE (
  %MEDIAINFOPATH% --inform=Video;%%Format%% %MKVFILE% > %TEMPINFO%
  FOR /F "tokens=*" %%A IN ('type %TEMPINFO%') DO IF NOT "%%A" == "" (SET VCODEC=%%A)
  IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
)

%MEDIAINFOPATH% --inform=Audio;%%ID%% %MKVFILE% > %TEMPINFO%
FOR /F "tokens=*" %%A IN ('type %TEMPINFO%') DO IF NOT "%%A" == "" (SET ATRACK=%%A)
IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
IF %ATRACK% == 0 (
  echo ERROR: Audio track not found.
  GOTO END
) ELSE (
  %MEDIAINFOPATH% --inform=Audio;%%Format%% %MKVFILE% > %TEMPINFO%
  FOR /F "tokens=*" %%A IN ('type %TEMPINFO%') DO IF NOT "%%A" == "" (SET ACODEC=%%A)
  IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
)
echo Video track found as #%VTRACK% (%VCODEC%)
echo Audio track found as #%ATRACK% (%ACODEC%)
echo.

:CHKTRACKS
IF "%VCODEC%" == "AVC" (
  SET VIDEOEXT=264
) ELSE (
  echo ERROR: Non-supported video format: %VCODEC%
  echo.
  GOTO END
)
IF "%ACODEC%" == "AC-3" (
  SET AUDIOEXT=ac3
) ELSE IF "%ACODEC%" == "DTS" (
  SET AUDIOEXT=dts
) ELSE IF "%ACODEC%" == "AAC" (
  SET AUDIOEXT=aac
) ELSE (
  echo ERROR: Non-supported audio format: %ACODEC%
  echo.
  GOTO END
)
%MEDIAINFOPATH% --inform="Audio;%%Channel(s)%%" %MKVFILE% > %TEMPINFO%
FOR /F "tokens=*" %%A IN ('type %TEMPINFO%') DO IF NOT "%%A" == "" (SET ACHANNEL=%%A)
IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
IF NOT "%ACHANNEL%" == "2" (
  echo.
  echo =======================================================
  echo WARNING: Downmix %ACHANNEL%ch to 2ch will lose quality!
  echo =======================================================
  echo.
)
SET DEMUXVIDEO="%TEMPDIR%\%DEMUXPREFIX%video.%VIDEOEXT%"
SET DEMUXAUDIO="%TEMPDIR%\%DEMUXPREFIX%audio.%AUDIOEXT%"
SET DECOMPAUDIO="%TEMPDIR%\%DEMUXPREFIX%audio_decomp.wav"
SET ENCAUDIO="%TEMPDIR%\%DEMUXPREFIX%audio_decomp.aac"

:EXTTRACKS
echo Extracting Video/Audio tracks from MKV ...
%MKVEXTPATH% tracks %MKVFILE% --no-ogg %VTRACK%:%DEMUXVIDEO% %ATRACK%:%DEMUXAUDIO%
echo.
:: If audio is AAC-LC, skip transcoding
IF "%ACODEC%" == "AAC" (
  %MEDIAINFOPATH% --inform="Audio;%%Format_Profile%%" %MKVFILE% > %TEMPINFO%
  FOR /F "tokens=*" %%A IN ('type %TEMPINFO%') DO IF "%%A" == "LC" (
    IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
    SET SKIPATRANS=1
    GOTO MUXMP4
  )
)

:DECOMPA
echo Decompressing %ACODEC% to WAV ...
IF NOT EXIST %DEMUXAUDIO% (
  echo ERROR: Demuxed audio %DEMUXAUDIO% not found!
  echo        Anything wrong with mkvextract?
  echo.
  GOTO END
)
%EAC3TOPATH% %DEMUXAUDIO% %DECOMPAUDIO% -down2 -down16
echo.

:CONVAAC
echo Converting WAV to AAC-LC ...
IF NOT EXIST %DECOMPAUDIO% (
  echo ERROR: Decompressed audio %DECOMPAUDIO% not found!
  echo        Anything wrong with eac3to?
  echo.
  GOTO END
)
%AACENCPATH% -if %DECOMPAUDIO% -of %ENCAUDIO% -br %AACBR% -lc
echo.

:MUXMP4
echo Muxing AVC/AAC to MP4 ...
IF %SKIPATRANS% == 1 (
  echo Mux using %DEMUXAUDIO% as audio.
  %MP4BOXPATH% -add %DEMUXVIDEO% -add %DEMUXAUDIO% -new %MP4FILE%
) ELSE IF EXIST %ENCAUDIO% (
  echo Mux using %ENCAUDIO% as audio.
  %MP4BOXPATH% -add %DEMUXVIDEO% -add %ENCAUDIO% -new %MP4FILE%
) ELSE (
  echo ERROR: Encoded audio %ENCAUDIO% not found!
  echo        Anything wrong with NeroAacEnc?
  echo.
  GOTO END
)
echo.

:CLEANUP
echo Clean up temporary files ...
IF EXIST %TEMPINFO% ( del /f /q %TEMPINFO% )
del /f /q %DEMUXPREFIX%*.*
echo.
echo Done.
echo.

:END

